	.include	"jaguar.inc"
	.include	"olistgpu.inc"
	.include	"blit.inc"
	.include	"joypad.inc"
	.include	"dejag.inc"

;*********** VIDEO ***********************************************
vclk			equ	376

horiz_per		equ	317778
sync_per		equ	46050
eq_per		equ	23500
front_porch	equ	17450
line_blank	equ	109500
disp_width	equ	1347					;(pixel width + 1) * 3
disp_height	equ	240					;this is in lines

; Horizontal computations

n_hp			equ	horiz_per/vclk
n_hbb		equ	((horiz_per-sync_per-front_porch)/vclk)+$400
n_hbe		equ	(line_blank-sync_per-front_porch)/vclk
n_hs			equ	((horiz_per-sync_per)/vclk)+$400
n_hvs		equ	(horiz_per-(2*sync_per))/vclk
n_heq		equ	(horiz_per-eq_per)/vclk
n_hde		equ	((disp_width/2)-1)+$400
n_hdb1		equ	((n_hp)-(disp_width/2))
n_hdb2		equ	n_hdb1

n_vp			equ	523
n_vee		equ	6
n_vbe		equ	40
n_vdb		equ	n_vbe-2				;n_vbe+4
n_vde		equ	n_vdb+(disp_height*2)
n_vbb		equ	n_vde
n_vs			equ	n_vp-10
n_veb		equ	n_vs-n_vee

SCRN_TOP		equ	n_vdb				;ypos of first line at top of screen
SCRN_BOTTOM	equ	n_vde				;xpos of first line below screen
SCRN_RIGHT	equ	448					;xpos of first column off right side of screen
;*******************************************************************


TITLE_OBJS	equ	4
;title screen
;crescent galaxy logo
;circle reserves logo
;ship

SEL_OBJS	equ	11
;background
;6 planets
;dash
;icon bar
;score bar
;cursor

GAME_OBJS	equ	52			;maximum objects during the game
; 1 background
; 1 station
; 1 station flag
;10 enemies
; 1 power up
; 1 cutter
; 4 cutter shots
; 1 player
; 8 bullets
; 8 enemy shots
; 1 bomb
; 1 special weapon
;10 foreground objects
; 1 icon bar
; 1 score bar
; 1 flash
; 1 message box

CONGRATS_OBJS	equ	11
;screen
;9 lines of text
;score bar

INTRO_OBJS	equ	4
;screen
;text
;icons
;score bar

;gamemode
TITLE_MODE		equ	0			;title screen
SELECT_MODE		equ	1			;level selection screen
GAME_MODE			equ	2			;during game
CONGRATS_MODE		equ	3			;congratulations screen

DASHYPOS			equ	SCRN_BOTTOM-114	;ypos of select screen dashboard

TILES_PER_LEVEL	equ	352			;total background tiles in one level
ODOM_END1			equ	(256*64)		;total tiles * tile width (when scrolling stops at end of level)
ODOM_END2			equ	(345*64)		;when scrolling stops after scrolling speed up (352 tiles - 7 that are visible)
SCROLL_SPEED		equ	1			;default scrolling speed for background
MAX_SCROLLSPD		equ	32			;maximum speed for scrolling
SCROLL_SPEEDF		equ	2			;default scrolling speed for foreground objects
FOREOBJS			equ	512
MAX_ODOM_FRONT		equ	(505*64)

END_LEVEL_DELAY	equ	200			;limit for counter that delays end of level after boss is destroyed (endlvdel)

TILE_HEIGHT		equ	288			;height of one tile
TOTAL_FRONT_OBJS	equ	10			;maximum foreground objects at one time

SCORE_DIGITS		equ	7			;maximum number of digits in the score
ICON_XPOS			equ	48			;xpos of information bar
ICON_YPOS			equ	SCRN_TOP+16	;ypos of information bar
SCORE_XPOS		equ	336			;xpos of score bar
SCORE_YPOS		equ	SCRN_TOP+18	;ypos of score bar

PAUSED_XPOS		equ	205			;xpos of paused message
PAUSED_YPOS		equ	SCRN_TOP+200	;ypos of paused message
PAUSED_HT			equ	18			;height of message object for paused
PAUSED_DWIDTH		equ	8			;iwidth of message object for paused
GAMEOVER_XPOS		equ	147			;xpos of game over message
GAMEOVER_YPOS		equ	SCRN_TOP+200	;ypos of game over message
GAMEOVER_HT		equ	18			;height of message object for game over
CONTINUE_XPOS		equ	147 			;xpos of press fire to continue message
CONTINUE_YPOS		equ	SCRN_TOP+200	;ypos of press fire to continue message
CONTINUE_HT		equ	18			;height of message object for continue
GAMEOVER_DWIDTH	equ	24			;dwidth for game over sign
CONTINUE_DWIDTH	equ	24			;dwidth for continue sign
CONT_TOGGLE		equ	88			;when to switch between game over and continue signs
CONT_DELAY		equ	80			;limit for cont_del (delay before you can continue so you see the game over sign)

PLR_HSPEED		equ	3			;horizontal speed for player
PLR_VSPEED		equ	2			;vertical speed for player

PLR_OWIDTH		equ	48			;width of player object
PLR_OHEIGHT		equ	33			;height of player object
PLR_DEPTH			equ	4			;O_DEPTH for player object
PLR_DWIDTH		equ	12			;O_DWIDTH for player ship
PLR_IWIDTH		equ	12			;O_IWIDTH for player ship
PLR_COLL_R		equ	37			;add to player xpos to get right edge for collision detection
PLR_COLL_L		equ	5			;add to player xpos to get left edge for collision detection
PLR_COLL_T		equ	12			;add to player ypos to get top edge for collision detection
PLR_COLL_B		equ	39			;add to player ypos to get bottom edge for collision detection

PLR_XPOS			equ	32			;default xpos for player
PLR_YPOS			equ	240			;default ypos for player
PLR_TOP_LIMIT		equ	SCRN_TOP		;highest ypos for player
PLR_BOT_LIMIT		equ	SCRN_BOTTOM-(PLR_OHEIGHT*2)		;lowest ypos for player
PLR_LEFT_LIMIT		equ	6			;farthest left xpos for player
PLR_RIGHT_LIMIT	equ	384			;farthest right xpos for player

SHIP_UPMAX		equ	0
SHIP_UPMID		equ	1
SHIP_NEUTRAL		equ	2
SHIP_DNMID		equ	3
SHIP_DNMAX		equ	4

MAX_JOYHOLD		equ	15			;maximum value for joyhold


CUTR_TIME			equ	940			;time limit for cutter

CUTR_BULLET_XPOS	equ	49			;add to cutter xpos to get bullet starting X position
CUTR_BULLET_YPOS	equ	18			;add to cutter ypos to get bullet starting Y position
CUTR_BULLETS		equ	4			;maximum bullets for cutter
CUTR_BULLET_SPEED	equ	8			;speed for cutter bullets
CUTR_SHOT_DELAY	equ	15			;delay between cutter shots
CUTR_SHOT_DMG		equ	6			;damage caused by cutter shots

;values for player+O_DESC
PLR_PLAY			equ	0			;player is in action
PLR_EXP			equ	1			;player is an explosion
PLR_FLASH			equ	2			;player is returning from being an explosion

PLR_FLASH_TIME		equ	106			;amount of time that player flashes after returning from being an explosion

SHOT_DELAY_TIME	equ	15			;frames between bullet shots
SPEC_DELAY_TIME	equ	56			;frames between uses of special weapons
LEV_DELAY_TIME		equ	10			;delay before you can fire at the start of a level

MAX_BULLETS		equ	8			;maximum active bullets at one time
BULLET_SPEED		equ	8			;horizontal speed for bullets
MAX_BULLET_POWER	equ	6			;maximum power level for bullets
BULLET_XPOS		equ	37			;add to player xpos to get starting xpos for bullet
BULLET0_YPOS		equ	26			;add to player ypos to get starting ypos for bullet
BULLET1_YPOS		equ	22			;add to player ypos to get starting ypos for bullet
BULLET2_YPOS		equ	20			;add to player ypos to get starting ypos for bullet
BULLET3_YPOS		equ	18			;add to player ypos to get starting ypos for bullet
BULLET4_YPOS		equ	8			;add to player ypos to get starting ypos for bullet
BULLET5_YPOS		equ	-2			;add to player ypos to get starting ypos for bullet

MAX_BOMB_POWER		equ	3
BOMB_XPOS			equ	12			;add to player xpos to get starting xpos for bomb
BOMB_YPOS			equ	24			;add to player ypos to get starting ypos for bomb

;special weapons
MAGNET			equ	0
TRACER			equ	1
BEAM				equ	2
FLASH			equ	3
MISSILE			equ	4
RING				equ	5
BOLT				equ	6
SHIELD			equ	7
CUTTER			equ	8			;make sure cutter is the last special weapon number
MAX_SPEC_WEAPONS	equ	9			;number of different special weapons

MAGNET_SPEED		equ	5			;horizontal speed for magnet
MAGNET_PULL		equ	6			;speed that enemies go toward magnet
TRACER_SPEED		equ	12			;horizontal speed for tracer
BEAM_SPEED		equ	11			;horizontal speed for beam after it is full width
BEAM_IWIDTH		equ	56			;maximum O_IWIDTH for beam
BEAM_TIME			equ	340			;time limit for beam, includes growing time
BEAM_X			equ	29			;add to player xpos to get beam xpos
BEAM_Y			equ	10			;add to player ypos to get beam ypos
FLASH_TIME		equ	16			;time limit for flash
MISSILE_SPEED		equ	11			;horizontal speed for missile
MISSILE_DIST		equ	165			;distance missiles travels before it explodes
RING_STEPS		equ	25			;number of steps in 1 circle around the player ship
RING_CNT			equ	16			;number of circles to do
BOLT_SPEED		equ	5			;horizontal speed for bolt special weapon
BOLT_HEIGHT		equ	138			;maximum height of bolt
SHIELD_TIME		equ	380			;time limit for shield
SHLD_X			equ	-8			;add to player xpos to get shield xpos
SHLD_Y			equ	-20			;add to player ypos to get shield ypos

BULLET_COLL_R		equ	5			;add to bullet xpos to get right edge for collision detection
BOMB_COLL_L		equ	1			;add to bomb xpos to get left edge for collision detection
BOMB_COLL_R		equ	15			;add to bomb xpos to get right edge for collision detection
BOMB_COLL_T		equ	0			;add to bomb ypos to get top edge for collision detection
BOMB_COLL_B		equ	23			;add to bomb ypos to get bottom edge for collision detection
BEAM_COLL_B		equ	8			;add to beam ypos to get bottom edge for collision detection
BOLT_COLL_L		equ	4			;add to bolt xpos to get left edge for collision detection
BOLT_COLL_R		equ	12			;add to bolt xpos to get right edge for collision detection
TRACER_COLL_L		equ	2			;add to tracer xpos to get left edge for collision detection
TRACER_COLL_R		equ	19			;add to tracer xpos to get right edge for collision detection
TRACER_COLL_T		equ	4			;add to tracer ypos to get top edge for collision detection
TRACER_COLL_B		equ	34			;add to tracer ypos to get bottom edge for collision detection
RING_COLL_L		equ	1			;add to ring xpos to get left edge for collision detection
RING_COLL_R		equ	23			;add to ring xpos to get right edge for collision detection
RING_COLL_T		equ	2			;add to ring ypos to get top edge for collision detection
RING_COLL_B		equ	36			;add to ring ypos to get bottom edge for collision detection
MAGNET_COLL_L		equ	2			;add to magnet xpos to get left edge for collision detection
MAGNET_COLL_R		equ	21			;add to magnet xpos to get right edge for collision detection
MAGNET_COLL_T		equ	2			;add to magnet ypos to get top edge for collision detection
MAGNET_COLL_B		equ	36			;add to magnet ypos to get bottom edge for collision detection
MISS_COLL_L		equ	0			;add to missile xpos to get left edge for collision detection
MISS_COLL_R		equ	19			;add to missile xpos to get right edge for collision detection
MISS_COLL_T		equ	1			;add to missile ypos to get top edge for collision detection
MISS_COLL_B		equ	16			;add to missile ypos to get bottom edge for collision detection
MISS_EXP_COLL_WD	equ	80			;add to missile explosion xpos to get right edge for collision detection
MISS_EXP_COLL_HT	equ	128			;add to missile explosion ypos to get right edge for collision detection
SHIELD_COLL_L		equ	8			;add to shield xpos to get left edge for collision detection
SHIELD_COLL_R		equ	48			;add to shield xpos to get right edge for collision detection
SHIELD_COLL_T		equ	13			;add to shield ypos to get top edge for collision detection
SHIELD_COLL_B		equ	77			;add to shield ypos to get bottom edge for collision detection

BULLET0_DAMAGE		equ	3			;bullet level 0
BULLET1_DAMAGE		equ	5			;bullet level 1
BULLET2_DAMAGE		equ	7			;bullet level 2
BULLET3_DAMAGE		equ	9			;bullet level 3
BULLET4_DAMAGE		equ	11			;bullet level 4
BULLET5_DAMAGE		equ	12			;bullet level 5
BOMB0_DAMAGE		equ	10			;level 0 bomb
BOMB1_DAMAGE		equ	15			;level 1 bomb
BOMB2_DAMAGE		equ	20			;level 2 bomb
TRACER_DAMAGE		equ	25
MAGNET_DAMAGE		equ	9
BEAM_DAMAGE		equ	2
FLASH_DAMAGE		equ	250
MISSILE_DAMAGE		equ	1
MISSEXP_DAMAGE		equ	20
RING_DAMAGE		equ	15
BOLT_DAMAGE		equ	4
SHIELD_DAMAGE		equ	0
PLR_COLL_DAMAGE	equ	5

TOTAL_ENEMIES		equ	10			;total enemy objects
;enemy types
PILLBUG			equ	0
SEYMOUR			equ	1
TURBORAT			equ	2
BATSKULL			equ	3
PROCKB			equ	4
PROCKM			equ	5
PROCKS			equ	6
BIGROCK			equ	7
MEDROCK			equ	8
SMLROCK			equ	9
BIGCRYS			equ	10
MDCRYSA			equ	11
MDCRYSB			equ	12
BSTAR			equ	13
MSTAR			equ	14
SPINNER			equ	15
SCORPSML			equ	16
SCORPBIG			equ	17
BUGGY			equ	18
CUBE				equ	19
SPHERE			equ	20
TRI_ALL			equ	21
TRI_3			equ	22
TRI_2			equ	23
TRI_1			equ	24
BAT				equ	25
BURPLEB			equ	26
BURPLES			equ	27
BUBBLEB			equ	28
BUBBLES			equ	29
PEBBLEB			equ	30
PEBBLEM			equ	31
PEBBLES			equ	32
FBUG				equ	33
HUMM				equ	34
VULT				equ	35
FLOWER			equ	36
GUNDINO			equ	37
FIREFLY			equ	38
SPIDERSM			equ	39
SPIDERBG			equ	40
KILRUN			equ	41
SADMASK			equ	42
FISHTX			equ	43
BABY				equ	44
DINO_SM			equ	45
ROBOT			equ	46
SNAKE			equ	47
GLOWBUG			equ	48
EYELGBL			equ	49
EYELGGR			equ	50
EYESMBL			equ	51
EYESMGR			equ	52
DRAGON			equ	53
;bosses
FIRST_BOSS_ENEMY	equ	54
DESRBTT			equ	FIRST_BOSS_ENEMY
DESRBTB			equ	FIRST_BOSS_ENEMY+1
AIRROBOT			equ	FIRST_BOSS_ENEMY+2
CVROBOT			equ	FIRST_BOSS_ENEMY+3
WRDBODY			equ	FIRST_BOSS_ENEMY+4
WRDTAIL			equ	FIRST_BOSS_ENEMY+5
WRDRARM			equ	FIRST_BOSS_ENEMY+6
WRDLARM			equ	FIRST_BOSS_ENEMY+7
CITYBOD			equ	FIRST_BOSS_ENEMY+8
CITYHD			equ	FIRST_BOSS_ENEMY+9
SERPBODY			equ	FIRST_BOSS_ENEMY+10
SERPWNGR			equ	FIRST_BOSS_ENEMY+11
SERPWNGL			equ	FIRST_BOSS_ENEMY+12
QUETBODY			equ	FIRST_BOSS_ENEMY+13
QUETARMB			equ	FIRST_BOSS_ENEMY+14
QUETARMF			equ	FIRST_BOSS_ENEMY+15
QUETTAIL			equ	FIRST_BOSS_ENEMY+16
;boss ground enemies
FIRST_GRD_ENEMY	equ	FIRST_BOSS_ENEMY+17
SKULLRIB			equ	FIRST_BOSS_ENEMY+17
SKULLARM			equ	FIRST_BOSS_ENEMY+18
SKULLHD			equ	FIRST_BOSS_ENEMY+19			;head
SKULLNECK			equ	FIRST_BOSS_ENEMY+20
SKULLHB			equ	FIRST_BOSS_ENEMY+21			;back horn
SKULLHF			equ	FIRST_BOSS_ENEMY+22			;front horn
SKULLHN			equ	FIRST_BOSS_ENEMY+23			;nose horn
ODDITCLD			equ	FIRST_BOSS_ENEMY+24
ODDIT			equ	FIRST_BOSS_ENEMY+25
MUDMAN			equ	FIRST_BOSS_ENEMY+26
;ground enemies
SPORE			equ	FIRST_BOSS_ENEMY+27
FERN				equ	FIRST_BOSS_ENEMY+28
DINO				equ	FIRST_BOSS_ENEMY+29
SLUG				equ	FIRST_BOSS_ENEMY+30
BALL				equ	FIRST_BOSS_ENEMY+31
BLOCKB			equ	FIRST_BOSS_ENEMY+32
BLOCKM			equ	FIRST_BOSS_ENEMY+33
BLOCKS			equ	FIRST_BOSS_ENEMY+34
GEYSER			equ	FIRST_BOSS_ENEMY+35
POPPY0			equ	FIRST_BOSS_ENEMY+36
POPPY1			equ	FIRST_BOSS_ENEMY+37
POPPY2			equ	FIRST_BOSS_ENEMY+38
TOWER			equ	FIRST_BOSS_ENEMY+39
ELEC				equ	FIRST_BOSS_ENEMY+40
MINGBOT			equ	FIRST_BOSS_ENEMY+41
FALLROCK			equ	FIRST_BOSS_ENEMY+42
RINGL0			equ	FIRST_BOSS_ENEMY+43
RINGM0			equ	FIRST_BOSS_ENEMY+44
RINGS0			equ	FIRST_BOSS_ENEMY+45

STATION			equ	200						;put in ground object list

 
;enemy actions *** need to change en_chg_time table and set_en_info code if number of actions changes ***
EN_DYING			equ	0			;enemy is dying
EN_APPEAR			equ	1			;enemy is appearing
EN_MOVING			equ	2			;enemy is moving	(2 sets of 16 steps)
EN_ATTACK			equ	3			;enemy is attacking	(32 steps)

STARTING_LIVES		equ	3			;number of lives in reserve at start of game
MAX_LIVES			equ	9			;maximum number of lives
FINAL_LEVEL		equ	9			;the number of the last level in the game
TOTAL_WORLDS		equ	5			;5 different planets

MAX_ENEMY_SHOTS	equ	8			;maximum enemy shots active at once
ENEMY_SHOT_TOP		equ	SCRN_TOP-60	;minimum ypos for enemy shots
ENEMY_SHOT_BOTTOM	equ	SCRN_BOTTOM	;maximum ypos for enemy shots
ENEMY_SHOT_LEFT	equ	$FFC0		;minimum xpos for enemy shots
ENEMY_SHOT_RIGHT	equ	SCRN_RIGHT	;maximum xpos for enemy shots

;shot types
BSKSHOT	equ	0
TRATSHOT	equ	1
SPITSHOT	equ	2
FERNSHOT	equ	3
SEYMSHOT	equ	4
SCRP_SHS	equ	5
SCRP_SHB	equ	6
BUG_SHOT	equ	7
CUBESHOT	equ	8
SPHERSH	equ	9
FBUGSHOT	equ	10
HUMMSHOT	equ	11
VULTSHOT	equ	12
GUNDSHOT	equ	13
FFLYSHOT	equ	14
KILRSHOT	equ	15
SADMSHOT	equ	16
DESRBSH0	equ	17		;to the right
DESRBSH1	equ	18		;to the left
FISHTXSH	equ	19
AIRRBSHT	equ	20
CVRBSH0	equ	21		;from tube
CVRBSH1	equ	22		;from arm
TRISH0	equ	23		;top of triangle
TRISH1	equ	24		;top middle of triangle
TRISH2	equ	25		;bottom middle of triangle
BABYSHOT	equ	26
CTYSHHD	equ	27		;shot from head
CTYSHMIS	equ	28		;missile from shoulder
CTYSHRNG	equ	29		;ring from waist
SLUGSHOT	equ	30
QUETSHOT	equ	31
SKULLSHH	equ	32		;shot from head
SKULLSHB	equ	33		;back horn
SKULLSHF	equ	34		;front horn
SKULLSHN	equ	35		;nose horn
DINOSHOT	equ	36		;big dino
ODDITSH0	equ	37		;oddit shot 0
ODDITSH1	equ	38		;oddit shot 1
MUDSHOT	equ	39		;mud man shot
SERPSHOT	equ	40		;serpent shot (lion fish)
WSHOTTL	equ	41		;weird robot tail shot
WSHOTHR	equ	42		;weird robot right hand shot
WSHOTHL	equ	43		;weird robot left hand shot
DRAGSHOT	equ	44		;dragon shot

;explosions
EXP_A	equ	0		;explosion A		(16 x 16)
EXP_B	equ	1		;explosion B		(32 x 24)
EXP_C	equ	2		;explosion C		(48 x 40)
EXP_D	equ	3		;explosion D		(80 x 64)
EXP_E	equ	4		;explosion E		(80 x 64 used for missile)
PILL_EXP	equ	5		;pillbug explosion	(24 x 24)
SEYM_EXP	equ	6		;seymour explosion	(48 x 64)
EXP_F	equ	7		;explosion F		(160 x 128)

PLR_EXPLOS_CHANGE	equ	3			;when to change plr_explosion anim step
PLR_EXPLOS_STEPS	equ	8			;animation steps for plr explosion

;powerup types
P_BULL1		equ	0
P_BULL2		equ	1
P_BULL3		equ	2
P_BULL4		equ	3
P_BULL5		equ	4
P_BOMB1		equ	5
P_BOMB2		equ	6
P_BEAM		equ	7
P_MAGNET		equ	8
P_LIFE		equ	9
P_MISS		equ	10
P_RING		equ	11
P_TRACE		equ	12
P_FLASH		equ	13
P_BOLT		equ	14
P_SHIELD		equ	15
P_POINTS		equ	16
TOTAL_POWERUPS	equ	P_POINTS+1


BUILDCODE		equ	0				;gpucode value when build code is in GPU RAM
DECOMPCODE	equ	1				;gpucode value when decompression code is in GPU RAM

;for build GPU code
BUILD_PRG		equ	$F03000
DONE_ADR		equ	$F03FD0			;1 when build is finished
OLISTR_ADR	equ	$F03FD4			;holds address of olist_ram
OLIST_ADR		equ	$F03FD8			;holds address of olist
FIRSTOBJ_ADR	equ	$F03FDC			;holds address of first object header for build
TOTOBJS_ADR	equ	$F03FE0			;holds total number of objects for build to process
BUILDING		equ	31				;DONE_ADR is set to this while list is being built, 1 when finished


;for uncomp GPU code
UNCOMP_PRG	equ	$F03400			;start of program
UNCOMP_START	equ	$F03FE8			;holds starting address of compressed mask
UNCOMP_DEST	equ	$F03FEC			;holds destination address for uncompressed data
UNCOMP_END	equ	$F03FF0			;end address for uncompressed data
UNCOMP_DONE	equ	$F03FF4			;1 when uncomp is done

;adjblack program uses the last part of GPU ram that is not used by the DEJAG code
;adjblack gets loaded into the GPU once at the beginning of the program and stays there
ADJBLACK_PRG	equ	$F03F80			;start of program
ADJBLACK_START	equ	$F03FE8			;holds start address for adjblack
ADJBLACK_END	equ	$F03FEC			;holds end address for adjblack
ADJBLACK_DONE	equ	$F03FF0			;1 when adjblack is done

FORM_PRG		equ	$F03800
FORM_X		equ	$F03C00
FORM_Y		equ	$F03C04
FORM_SIZE		equ	$F03C08
FORM_RADIUS	equ	$F03C0C
FORM_XPOS		equ	$F03C10
FORM_YPOS		equ	$F03C14
FORM_SN		equ	$F03C18
FORM_DONE		equ	$F03C1C


;SOUND STUFF
;______________________________________________________________________________
;Tables are positioned every 80 bytes. The first long word of an entry is
;always the module type. A module type of zero indicates the end of the list.
;A module tpye of -4 is skipped.

TIMELEFT		equ	D_RAM+16+12
;MIDIvol         equ     D_RAM+12
EFFECTPOS       equ     D_RAM+$1ff0
EFFBUFF         equ     $401000		; Used when there are effects
BUFFLEN         equ     $ffff			; Used when there are effects
STACKPOS        equ     D_RAM+16
tablestart      equ     D_RAM+$800
taboff          equ     20*4

MAX_VOICES	equ	8

;sounds
CAT_SND		equ	0
EXPLOS0_SND	equ	1
EXPLOS1_SND	equ	2
MAGNET_SND	equ	3
PLRFIRE_SND	equ	4
RINGWPN_SND	equ	5
SHIELD_SND	equ	6
LAUNCH_SND	equ	7
TRACER_SND	equ	8
EXPLOS2_SND	equ	9
FIRE_SND		equ	10
BLOWUP1_SND	equ	11
BLOWUP2_SND	equ	12
BLOWUP3_SND	equ	13
BUZZER_SND	equ	14
ELECTRIC_SND	equ	15
HITNOKIL_SND	equ	16
PICKUP_SND	equ	17
SELECTX_SND	equ	18 
SMALLHIT_SND	equ	19

FIRST_FM		equ	20
DESRBT0_SND	equ	FIRST_FM
DESRBT1_SND	equ	FIRST_FM+1
SKULL0_SND	equ	FIRST_FM+2
SKULL1_SND	equ	FIRST_FM+3
CVROBOT0_SND	equ	FIRST_FM+4
CVROBOT1_SND	equ	FIRST_FM+5
QUET0_SND		equ	FIRST_FM+6
QUET1_SND		equ	FIRST_FM+7
AIRRBT0_SND	equ	FIRST_FM+8
AIRRBT1_SND	equ	FIRST_FM+9
LION0_SND		equ	FIRST_FM+10
LION1_SND		equ	FIRST_FM+11
WRDRBT0_SND	equ	FIRST_FM+12
WRDRBT1_SND	equ	FIRST_FM+13
MUDMAN0_SND	equ	FIRST_FM+14
MUDMAN1_SND	equ	FIRST_FM+15
CITYRBT0_SND	equ	FIRST_FM+16
CITYRBT1_SND	equ	FIRST_FM+17
ODDIT0_SND	equ	FIRST_FM+18
ODDIT1_SND	equ	FIRST_FM+19

FM20			equ	FIRST_FM+20
FIRE0_SND		equ	FIRST_FM+21			;short gunshot
FIRE1_SND		equ	FIRST_FM+22			;like launch
FIRE2_SND		equ	FIRST_FM+23
BEAM_SND		equ	FIRST_FM+24
FM25			equ	FIRST_FM+25
FM26			equ	FIRST_FM+26
FM27			equ	FIRST_FM+27
FM28			equ	FIRST_FM+28
FM29			equ	FIRST_FM+29

BOMB_SND		equ	FIRST_FM+30

TOTAL_SOUNDS	equ	BOMB_SND+1

CHEAT_CODE1	equ	$03080B05					;keys 1 - 4
CHEAT_CODE2	equ	$07110C0F					;keys 5 - 8


;conditional stuff
COLLISIONS	equ 1	;0 = no collision detection for player

SHOW_PAUSED	equ 1	;0 = don't displayed the paused sign when game is paused

RANDOM_LEVEL	equ 0 	;0 = use the list of background tiles from the rom table
					;1 = make a random list of background tiles for current level

CHEAT_ON		equ 1	;0 = cheat mode off unless chtcode is correct
					;1 = cheat mode always on
